/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.conf.filter;

import com.google.common.collect.Lists;
import com.pamirs.tro.entity.annocation.DataAuth;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.cloud.common.utils.CustomUtil;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.conf.filter.MybatisDataAuthInterceptor;
import io.shulie.tro.web.app.utils.TroUserUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MybatisDataAuthInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisDataAuthInterceptor.class);
    public static final String AUTH_COLUMN = "user_id";
    private static final String BOUND_SQL = "sqlSource.boundSql.sql";

    public Object intercept(Invocation arg0) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)arg0.getArgs()[0];
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return arg0.proceed();
        }
        if (RestContext.getTenantUserKey() != null) {
            return arg0.proceed();
        }
        if (TroUserUtil.validateSuperAdmin((User)RestContext.getUser()).booleanValue()) {
            return arg0.proceed();
        }
        if (this.allowAll().booleanValue()) {
            return arg0.proceed();
        }
        Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
        String methodName = mappedStatement.getId().substring(mappedStatement.getId().lastIndexOf(".") + 1);
        for (Method method : classType.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(DataAuth.class) || !methodName.equals(method.getName())) continue;
            BoundSql boundSql = mappedStatement.getBoundSql(arg0.getArgs()[1]);
            DataAuth action = method.getAnnotation(DataAuth.class);
            Select select = (Select)CCJSqlParserUtil.parse((String)boundSql.getSql());
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            InExpression inExpression = new InExpression();
            ExpressionList expressionList = new ExpressionList();
            expressionList.setExpressions(this.getExpressionList(mappedStatement.getId()));
            inExpression.setLeftExpression((Expression)new Column(new Table(action.tableAlias()), AUTH_COLUMN));
            inExpression.setRightItemsList((ItemsList)expressionList);
            plainSelect.setWhere((Expression)new AndExpression(plainSelect.getWhere(), (Expression)inExpression));
            MappedStatement newMappedStatement = this.newMappedStatement(mappedStatement, (SqlSource)new BoundSqlSqlSource(this, boundSql));
            MetaObject metaObject = MetaObject.forObject((Object)newMappedStatement, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
            metaObject.setValue(BOUND_SQL, (Object)plainSelect.toString());
            arg0.getArgs()[0] = newMappedStatement;
        }
        return arg0.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties arg0) {
    }

    private MappedStatement newMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private List<Expression> getExpressionList(String mappedStatementId) {
        List allowUserIdList = RestContext.getQueryAllowUserIdList();
        if (CollectionUtils.isEmpty((Collection)allowUserIdList)) {
            log.warn("RestContext AllowUserIdList Is Empty.... userId={}, mappedStatementId={}", (Object)CustomUtil.getUserId(), (Object)mappedStatementId);
            return Lists.newArrayList((Object[])new Expression[]{new LongValue(-1L)});
        }
        ArrayList expressionList = Lists.newArrayList();
        allowUserIdList.stream().forEach(data -> expressionList.add(new LongValue(data.longValue())));
        return expressionList;
    }

    private Boolean allowAll() {
        List allowUserIdList = RestContext.getQueryAllowUserIdList();
        if (CollectionUtils.isEmpty((Collection)allowUserIdList)) {
            return true;
        }
        return false;
    }
}

