/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.conf;

import io.shulie.tro.channel.ServerChannel;
import io.shulie.tro.channel.protocal.ChannelProtocol;
import io.shulie.tro.channel.router.zk.DefaultServerChannel;
import io.shulie.tro.channel.router.zk.ZkClientConfig;
import io.shulie.tro.web.app.utils.JsonChannelProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommandChannelConfig {
    private static final Logger log = LoggerFactory.getLogger(CommandChannelConfig.class);
    @Value(value="${tro.config.zk.addr}")
    private String zkPath;

    @Bean
    public ServerChannel registerChannel() {
        ServerChannel channel = null;
        try {
            ZkClientConfig config = new ZkClientConfig();
            config.setZkServers(this.zkPath);
            channel = new DefaultServerChannel().build(config).setChannelProtocol((ChannelProtocol)new JsonChannelProtocol());
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return channel;
    }
}

