/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.common;

import com.github.pagehelper.PageInfo;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.response.BaseResponse;
import io.shulie.tro.web.common.domain.ErrorInfo;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class Response<T> {
    public static final String PAGE_TOTAL_HEADER = "x-total-count";
    public static final boolean DEFAULT_SUCCESS = true;
    private ErrorInfo error;
    @ApiModelProperty(name="data", value="\u8fd4\u56de\u7684\u5177\u4f53\u6570\u636e")
    private T data;
    @ApiModelProperty(name="success", value="\u662f\u5426\u6210\u529f")
    private Boolean success;
    private Boolean unsuccess;

    public Response(T data) {
        this(null, data, true);
    }

    public Response(ErrorInfo error, boolean success) {
        this(error, null, success);
    }

    public Response(ErrorInfo error, T data, boolean success) {
        this.error = error;
        this.data = data;
        this.success = success;
    }

    public Response(ErrorInfo error, T data, boolean success, int code) {
        this.error = error;
        this.data = data;
        this.success = success;
    }

    public static Response failByType(String code, String msgTemplate, String headerType) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        response.setHeader("Access-Control-Expose-Headers", "type");
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.setMsgTemplate(msgTemplate);
        response.setHeader("type", headerType);
        return new Response(errorInfo, null, false, Integer.parseInt(code));
    }

    public static <T> Response<T> success() {
        return new Response(null);
    }

    public static <T> Response<T> success(T data) {
        if (data instanceof PageInfo) {
            return Response.success(data);
        }
        if (data instanceof List) {
            return Response.successList((List)((List)data));
        }
        return new Response(data);
    }

    public static Response<List> successList(List data) {
        Response.permissionHook((List)data);
        return new Response((Object)data);
    }

    public static <T> Response<List<T>> success(PageInfo<T> data) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        response.setHeader("Access-Control-Expose-Headers", "x-total-count");
        response.setHeader("x-total-count", data.getTotal() + "");
        Response.permissionHook(data);
        return new Response((Object)data.getList());
    }

    private static <T> void permissionHook(List<T> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            T responseObj = list.get(i);
            if (!(responseObj instanceof BaseResponse)) continue;
            BaseResponse baseResponse = (BaseResponse)responseObj;
            baseResponse.permissionControl();
        }
    }

    private static <T> void permissionHook(PageInfo<T> data) {
        Response.permissionHook((List)data.getList());
    }

    public static <T> Response<List<T>> successPagingList(PagingList<T> data) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        response.setHeader("Access-Control-Expose-Headers", "x-total-count");
        response.setHeader("x-total-count", data.getTotal() + "");
        return new Response((Object)data.getList());
    }

    public static <T> Response<List<T>> success(List<T> data, long total) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        response.setHeader("Access-Control-Expose-Headers", "x-total-count");
        response.setHeader("x-total-count", total + "");
        return new Response(data);
    }

    public static Response fail(String code, String msgTemplate, Object ... args) {
        OperationLogContextHolder.ignoreLog();
        ErrorInfo errorInfo = ErrorInfo.build((String)code, (String)msgTemplate, (Object[])args);
        return new Response(errorInfo, false);
    }

    public static Response fail(String msgTemplate, Object ... args) {
        OperationLogContextHolder.ignoreLog();
        ErrorInfo errorInfo = ErrorInfo.build((String)"500", (String)msgTemplate, (Object[])args);
        return new Response(errorInfo, false);
    }

    public Response setTotal(Long total) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        response.setHeader("Access-Control-Expose-Headers", "x-total-count");
        response.setHeader("x-total-count", total + "");
        return this;
    }

    public ErrorInfo getError() {
        return this.error;
    }

    public void setError(ErrorInfo error) {
        this.error = error;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }
}

