/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.common;

import com.alibaba.druid.filter.config.ConfigTools;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.pagehelper.Page;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.TROConstantEnum;
import com.pamirs.tro.common.constant.TRODictTypeEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.redis.RedisManager;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.common.util.Snowflake;
import com.pamirs.tro.entity.dao.assist.loaddata.TLoadDataDao;
import com.pamirs.tro.entity.dao.assist.loaddata.TReturnDataDao;
import com.pamirs.tro.entity.dao.common.CommonDao;
import com.pamirs.tro.entity.dao.confcenter.TApplicationIpDao;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.confcenter.TBListMntDao;
import com.pamirs.tro.entity.dao.confcenter.TBaseConfigDao;
import com.pamirs.tro.entity.dao.confcenter.TFirstLinkMntDao;
import com.pamirs.tro.entity.dao.confcenter.TLinkMntDao;
import com.pamirs.tro.entity.dao.confcenter.TLinkTopologyInfoDao;
import com.pamirs.tro.entity.dao.confcenter.TSecondBasicDao;
import com.pamirs.tro.entity.dao.confcenter.TSecondLinkMntDao;
import com.pamirs.tro.entity.dao.confcenter.TShadowTableConfigDao;
import com.pamirs.tro.entity.dao.confcenter.TShadowTableDataSourceDao;
import com.pamirs.tro.entity.dao.confcenter.TWListMntDao;
import com.pamirs.tro.entity.dao.dict.TDictDao;
import com.pamirs.tro.entity.dao.dict.TDictionaryTypeMapper;
import com.pamirs.tro.entity.dao.monitor.TAlarmDao;
import com.pamirs.tro.entity.dao.monitor.TAlarmMonitorDao;
import com.pamirs.tro.entity.dao.monitor.TReportAppIpDetailDao;
import com.pamirs.tro.entity.dao.monitor.TReportDao;
import com.pamirs.tro.entity.dao.pressureready.TDataBuildDao;
import com.pamirs.tro.entity.dao.pressureready.TLinkDetectionDao;
import com.pamirs.tro.entity.dao.preventcheat.TApplicationInfoUploadDao;
import com.pamirs.tro.entity.dao.preventcheat.TApplicationMntConfigDao;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.BTRelationLink;
import com.pamirs.tro.entity.domain.entity.RelationLinkModel;
import com.pamirs.tro.entity.domain.query.Conf;
import com.pamirs.tro.entity.domain.vo.TLinkApplicationInterfaceVo;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.service.AopsService;
import io.shulie.tro.web.app.service.TAlarmService;
import io.shulie.tro.web.app.service.TFirstLinkMntService;
import io.shulie.tro.web.app.service.TReportService;
import io.shulie.tro.web.app.service.TSecondLinkMntService;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonService {
    private static AtomicInteger cursor = new AtomicInteger(1);
    public final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected TApplicationMntDao tApplicationMntDao;
    @Autowired
    protected TBListMntDao tBListMntDao;
    @Autowired
    protected TLinkMntDao tLinkMnDao;
    @Autowired
    protected Snowflake snowflake;
    @Autowired
    protected TAlarmDao tAlarmDao;
    @Autowired
    protected TAlarmMonitorDao tAlarmMonitorDao;
    @Autowired
    protected TFirstLinkMntDao firstLinkMntDao;
    @Autowired
    protected TSecondBasicDao secondBasicDao;
    @Autowired
    protected TSecondLinkMntDao secondLinkDao;
    @Autowired
    protected TDictDao tDicDao;
    @Autowired
    protected CommonDao commonDao;
    @Autowired
    protected TApplicationIpDao tApplicationIpDao;
    @Autowired
    protected TDataBuildDao TDataBuildDao;
    @Autowired
    protected TWListMntDao tWListMntDao;
    @Autowired
    protected TLinkDetectionDao TLinkDetectionDao;
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    protected RedisManager redisManager;
    @Autowired
    protected TReportDao tReportDao;
    @Autowired
    protected TSecondLinkMntService tSecondLinkMntService;
    @Autowired
    protected AopsService aopsService;
    @Autowired
    protected TReportAppIpDetailDao tReportAppIpDetailDao;
    @Autowired
    protected TAlarmService tAlarmService;
    @Autowired
    protected ConfigSyncService configSyncService;
    @Autowired
    @Qualifier(value="ScriptThreadPool")
    protected ThreadPoolExecutor runShellTaskExecutor;
    @Autowired
    @Qualifier(value="loadDataThreadPool")
    protected ThreadPoolExecutor loadDataThreadPool;
    @Autowired
    @Qualifier(value="schedulerPool")
    protected TaskScheduler taskScheduler;
    @Autowired
    @Qualifier(value="asynExecuteScriptThreadPool")
    protected Executor asynExecuteScriptThreadPool;
    @Autowired
    protected SqlSessionFactory sqlSessionFactory;
    @Autowired
    protected TDictionaryTypeMapper tDictionaryTypeMapper;
    @Autowired
    protected TSecondLinkMntDao secondLinkMntDao;
    @Autowired
    protected TLinkMntDao tLinkMntDao;
    @Autowired
    protected TReportService tReportService;
    @Autowired
    protected TFirstLinkMntService firstLinkService;
    @Autowired
    protected TSecondBasicDao tSecondBasicDao;
    @Autowired
    protected TShadowTableConfigDao tShadowTableConfigDao;
    @Autowired
    protected TShadowTableDataSourceDao tShadowTableDataSourceDao;
    @Autowired
    protected TLoadDataDao TLoadDataDao;
    @Autowired
    protected TReturnDataDao returnDataDao;
    @Autowired
    protected TApplicationMntConfigDao tApplicationMntConfigDao;
    @Autowired
    protected TBaseConfigDao tbaseConfigDao;
    @Autowired
    protected TApplicationInfoUploadDao tApplicationInfoUploadDao;
    @Autowired
    protected TLinkTopologyInfoDao tLinkTopologyInfoDao;
    @Autowired
    protected TUserMapper TUserMapper;
    @Value(value="${basePath}")
    private String basePath;
    @Value(value="${pradar_url}")
    private String pradarUrl;
    @Value(value="${loadSqlPath}")
    private String loadSqlPath;
    @Value(value="${pm.prefix}")
    private String pmPrefix;
    @Value(value="${mq.script.name}")
    private String mqScriptName;
    @Value(value="${mq.producer.script.name}")
    private String mqProducerScriptName;
    @Value(value="${read.count}")
    private int readCount;
    @Value(value="${loadDataFile}")
    private String loadDataFile;
    @Value(value="${jar.upload.path}")
    private String jarUploadPath;

    public String getPradarUrl() {
        return this.pradarUrl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getLoadSqlPath() {
        return this.loadSqlPath;
    }

    public String getPmPrefix() {
        return this.pmPrefix;
    }

    public String getMqScriptName() {
        return this.mqScriptName;
    }

    public String getLoadDataFile() {
        return this.loadDataFile;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public String getMqProducerScriptName() {
        return this.mqProducerScriptName;
    }

    public String getJarUploadPath() {
        return this.jarUploadPath;
    }

    protected Map<String, Object> switchCaseFromMap(Map<String, Object> map) {
        HashMap resultMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            resultMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return resultMap;
    }

    public <T> T transferElementToString(T obj) {
        Map map;
        if (obj == null) {
            return obj;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (list.isEmpty()) {
                return (T)Lists.newArrayList();
            }
        } else if (obj instanceof Map && (map = (Map)obj).isEmpty()) {
            return (T)Maps.newHashMap();
        }
        if (obj instanceof Map) {
            Map rMap = (Map)obj;
            HashMap resultMap = Maps.newHashMap();
            for (Map.Entry entry : rMap.entrySet()) {
                if (entry.getValue() instanceof List) {
                    List innerList = (List)entry.getValue();
                    resultMap.put(entry.getKey(), this.transferElementToString((Object)innerList));
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    Map innerMap = (Map)entry.getValue();
                    resultMap.put(entry.getKey(), this.transferElementToString((Object)innerMap));
                    continue;
                }
                if (entry.getValue() instanceof String) {
                    resultMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Date) {
                    resultMap.put(entry.getKey(), DateUtils.transferDateToString(entry.getValue()));
                    continue;
                }
                resultMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
            return (T)resultMap;
        }
        if (obj instanceof List) {
            List rList = (List)obj;
            ArrayList list = Lists.newArrayList();
            for (Map map2 : rList) {
                list.add(this.transferElementToString((Object)map2));
            }
            return (T)list;
        }
        return obj;
    }

    public <T> List<T> executeWorktask(Executor executor, Collection<Callable<T>> workTasks) throws InterruptedException, ExecutionException {
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        workTasks.forEach(workTask -> completionService.submit(workTask));
        ArrayList newArrayList = Lists.newArrayList();
        for (int i = 0; i < workTasks.size(); ++i) {
            newArrayList.add(completionService.take().get());
        }
        return newArrayList;
    }

    public Map<String, Object> monitorThreadPoolInfo(ThreadPoolExecutor executor, String threadPoolName) {
        this.LOGGER.info(String.format(threadPoolName + " \u521d\u59cb\u7ebf\u7a0b\u6570: %d, \u6838\u5fc3\u7ebf\u7a0b\u6570: %d, \u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u6570\u91cf: %d, \u5df2\u5b8c\u6210\u4efb\u52a1\u6570\u91cf: %d, \u4efb\u52a1\u603b\u6570: %d, \u961f\u5217\u91cc\u7f13\u5b58\u7684\u4efb\u52a1\u6570\u91cf: %d, \u6c60\u4e2d\u5b58\u5728\u7684\u6700\u5927\u7ebf\u7a0b\u6570: %d, \u6700\u5927\u5141\u8bb8\u7684\u7ebf\u7a0b\u6570: %d,  \u7ebf\u7a0b\u7a7a\u95f2\u65f6\u95f4: %d, \u7ebf\u7a0b\u6c60\u662f\u5426\u5173\u95ed: %s, \u7ebf\u7a0b\u6c60\u662f\u5426\u7ec8\u6b62: %s", executor.getPoolSize(), executor.getCorePoolSize(), executor.getActiveCount(), executor.getCompletedTaskCount(), executor.getTaskCount(), executor.getQueue().size(), executor.getLargestPoolSize(), executor.getMaximumPoolSize(), executor.getKeepAliveTime(TimeUnit.MILLISECONDS), executor.isShutdown(), executor.isTerminated()));
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setPageInfo(List<Map<String, Object>> querySubjectlist, PageInfo<Map<String, Object>> pageInfo) {
        if (querySubjectlist instanceof Page) {
            Page page = (Page)querySubjectlist;
            pageInfo.setPageNum(page.getPageNum());
            pageInfo.setTotal(page.getTotal());
        }
    }

    @Deprecated
    public List<TLinkApplicationInterfaceVo> selectLinkApplicationInfo(String linkId) {
        return this.commonDao.selectLinkApplicationInfo(linkId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean batchInsertByMapper(SqlSessionFactory sqlSessionFactory, Class<?> mapperClass, Class pojoClass, String methodName, List<?> objList) {
        SqlSession session = sqlSessionFactory.openSession(ExecutorType.BATCH, false);
        boolean addCheck = true;
        Class[] paramTypes = new Class[1];
        Object mapper = session.getMapper(mapperClass);
        try {
            paramTypes[0] = Class.forName(pojoClass.getName());
            Method method = mapperClass.getMethod(methodName, paramTypes);
            for (Object obj : objList) {
                Map objectMap = (Map)obj;
                Map keys = (Map)objectMap.get("map");
                HashMap notNullValue = Maps.newHashMapWithExpectedSize((int)10);
                for (Map.Entry entry : keys.entrySet()) {
                    if (entry.getValue() == null) continue;
                    notNullValue.put(entry.getKey(), entry.getValue());
                }
                objectMap.put("map", notNullValue);
                method.invoke(mapper, obj);
            }
            session.flushStatements();
            session.commit();
            session.clearCache();
        }
        catch (Exception ex) {
            this.LOGGER.error("\u6279\u91cf\u6dfb\u52a0/\u66f4\u65b0\u5931\u8d25 methodName:" + methodName, (Throwable)ex);
            addCheck = false;
            session.rollback();
        }
        finally {
            session.close();
        }
        return addCheck;
    }

    @Deprecated
    public List<TLinkApplicationInterfaceVo> selectLinkWholeInfo(String linkId) {
        return this.commonDao.selectLinkWholeInfo(linkId);
    }

    protected String filterIllegalCharacters(String str) {
        ArrayList lists = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        str = StringUtils.trimToEmpty((String)str);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == '\uff0b' || c == '\uff0d' || c == '(' || c == ')' || c == '!' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '?' || c == '&' || c == '/' || c == '\u3002' || c == '\u3011' || c == '\u3010' || c == '\uff01' || c == '\uff1b' || c == '\uff1f' || c == '\uff08' || c == '\uff09' || c == '\u201c' || c == '\u201d' || c == '\'' || c == '\uff07' || c == '\uff02' || Character.isWhitespace(c)) {
                sb.append("");
                continue;
            }
            sb.append(c);
        }
        return StringUtils.trimToEmpty((String)sb.toString()).trim();
    }

    protected void closeAll(BufferedReader reader, InputStream inputStream, ByteArrayOutputStream bytes, Process ... processes) {
        if (processes != null) {
            for (Process process : processes) {
                if (process == null) continue;
                process.destroy();
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                this.LOGGER.info("PressureMeasurementAssistService.closeAll \u5173\u95ed\u6d41\u5f02\u5e38{}", (Throwable)e);
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.LOGGER.info("PressureMeasurementAssistService.closeAll \u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38{}", (Throwable)e);
            }
        }
        if (bytes != null) {
            try {
                bytes.close();
            }
            catch (IOException e) {
                this.LOGGER.info("PressureMeasurementAssistService.closeAll \u5173\u95ed\u5b57\u8282\u6570\u7ec4\u8f93\u51fa\u6d41\u5f02\u5e38{}", (Throwable)e);
            }
        }
    }

    public void closeAll(PreparedStatement ps, Connection conn, ResultSet rs) {
        try {
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> queryDicList(TRODictTypeEnum troDictTypeEnum) {
        List queryWListDic = this.tDicDao.queryDicList(troDictTypeEnum.toString());
        if (queryWListDic.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap dicList = Maps.newHashMap();
        HashMap resultMap = Maps.newHashMap();
        queryWListDic.forEach(map -> resultMap.put(MapUtils.getString((Map)map, (Object)TROConstantEnum.VALUE_ORDER.toString()), MapUtils.getString((Map)map, (Object)TROConstantEnum.VALUE_NAME.toString())));
        dicList.put("dicList", resultMap);
        dicList.put("dictType", MapUtils.getString((Map)((Map)queryWListDic.get(0)), (Object)TROConstantEnum.DICT_TYPE.toString()));
        return dicList;
    }

    protected void saveRelationLink(Long parentLinkId, String childLinks, String objTable) {
        if (StringUtils.isEmpty((CharSequence)childLinks)) {
            this.LOGGER.info("\u4e0b\u5c5e\u94fe\u8def\u4e3a\u7a7a");
            return;
        }
        List jsonList = (List)JSON.parseObject((String)childLinks, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        for (int i = 0; i < jsonList.size(); ++i) {
            List childLinkList = (List)jsonList.get(i);
            for (int j = 0; j < childLinkList.size(); ++j) {
                String childLinkId = (String)childLinkList.get(j);
                BTRelationLink relationLinkModel = new BTRelationLink();
                relationLinkModel.setObjTable(objTable);
                relationLinkModel.setParentLinkId(parentLinkId.longValue());
                relationLinkModel.setChildLinkId(Long.parseLong(childLinkId));
                relationLinkModel.setLinkBank(i + 1);
                relationLinkModel.setLinkOrder(j + 1);
                this.commonDao.saveRelationLink((RelationLinkModel)relationLinkModel);
            }
        }
    }

    public List<List<Map<String, Object>>> getRelationLinkRelationShip(String objTable, String parentLinkId) {
        List relationShipLists = this.commonDao.queryRelationLinkRelationShip(objTable, parentLinkId);
        if (CollectionUtils.isEmpty((Collection)relationShipLists)) {
            return Lists.newArrayList();
        }
        ConcurrentMap<String, List<Map>> groupBasicLink = relationShipLists.stream().collect(Collectors.groupingByConcurrent(map -> MapUtils.getString((Map)map, (Object)"LINK_BANK")));
        ArrayList baseLinkList = Lists.newArrayListWithCapacity((int)groupBasicLink.size());
        groupBasicLink.forEach((string, mapList) -> {
            Iterator iterator = mapList.iterator();
            while (iterator.hasNext()) {
                ((Map)iterator.next()).remove("LINK_BANK");
            }
            baseLinkList.add(mapList);
        });
        return baseLinkList;
    }

    public List<String> splitStrings(String separator, String string) throws TROModuleException {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{separator, string})) {
            throw new TROModuleException("\u5206\u9694\u7b26\u6216\u8005\u5e26\u5206\u9694\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Splitter.on((String)separator).omitEmptyStrings().trimResults().splitToList((CharSequence)string).stream().distinct().collect(Collectors.toList());
    }

    public <T> T dymanicGenerateDataSource(Class<T> t, Conf conf) throws Exception {
        DruidDataSource druidDataSource = this.createDataSource(conf);
        if (t.isAssignableFrom(SqlSessionFactory.class)) {
            SqlSessionFactory sqlSessionFactory = null;
            sqlSessionFactory = this.sqlSessionFactoryBean((DataSource)druidDataSource);
            return (T)sqlSessionFactory;
        }
        if (t.isInstance(JdbcTemplate.class)) {
            JdbcTemplate jdbcTemplate = new JdbcTemplate();
            jdbcTemplate.setDataSource((DataSource)druidDataSource);
            return (T)jdbcTemplate;
        }
        throw new RuntimeException("\u521b\u5efa\u6570\u636e\u6e90\u65f6,\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    public DruidDataSource createDataSource(Conf conf) throws SQLException {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setInitialSize(5);
        dataSource.setMinIdle(5);
        dataSource.setMaxActive(30);
        dataSource.setConnectionErrorRetryAttempts(2);
        dataSource.setQueryTimeout(30);
        dataSource.setMaxWait(60000L);
        dataSource.setTimeBetweenEvictionRunsMillis(6000L);
        dataSource.setMinEvictableIdleTimeMillis(60000L);
        dataSource.setValidationQuery("SELECT 1 FROM DUAL");
        dataSource.setTestWhileIdle(true);
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        StatFilter statFilter = new StatFilter();
        statFilter.setSlowSqlMillis(1000L);
        statFilter.setLogSlowSql(true);
        dataSource.setProxyFilters(Stream.of(statFilter).collect(Collectors.toList()));
        dataSource.setFilters("stat,slf4j");
        dataSource.setDriverClassName(conf.getDriverClassName());
        dataSource.setUrl(conf.getUrl());
        dataSource.setUsername(conf.getUsername());
        try {
            dataSource.setPassword(ConfigTools.decrypt((String)conf.getPublicKey(), (String)conf.getPasswd()));
        }
        catch (Exception e) {
            this.LOGGER.error("\u751f\u6210dataSource \u5f02\u5e38 {}", (Throwable)e);
        }
        return dataSource;
    }

    public SqlSessionFactory sqlSessionFactoryBean(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setTypeAliasesPackage("com.pamirs.tro.entity.dao");
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:com/pamirs/tro/entity/mapper/**/*.xml"));
        bean.setConfigLocation(new DefaultResourceLoader().getResource("classpath:ibatis.xml"));
        return bean.getObject();
    }

    public Connection getConnection(Conf conf) {
        Connection conn = null;
        try {
            Class.forName(conf.getDriverClassName());
            conn = DriverManager.getConnection(conf.getUrl(), conf.getUsername(), ConfigTools.decrypt((String)conf.getPublicKey(), (String)conf.getPasswd()));
        }
        catch (Exception e) {
            this.LOGGER.error("getConnection \u83b7\u53d6\u94fe\u63a5\u5931\u8d25", (Throwable)e);
        }
        return conn;
    }

    public List<Map<String, Object>> selectResultSet(String sql, Object[] objs, Connection con, int count) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        PreparedStatement ps = null;
        Object resultSet = null;
        try {
            ps = con.prepareStatement(sql, 1004, 1007);
            ps.setFetchSize(1000);
            ps.setFetchDirection(1000);
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    ps.setObject(i + 1, objs[i] + "");
                }
            }
            ResultSet rs = ps.executeQuery();
            rs.absolute(cursor.get());
            rs.previous();
            System.out.println("cursor \u73b0\u5728\u662f\u591a\u5c11" + cursor.get());
            ResultSetMetaData colinfo = rs.getMetaData();
            int cols = colinfo.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < cols; ++i) {
                    map.put(colinfo.getColumnName(i + 1), rs.getObject(i + 1));
                }
                list.add(map);
                if (count == 0 || list.size() != count) continue;
                return list;
            }
        }
        catch (SQLException e) {
            this.LOGGER.error("sql\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    public Runnable shoe(Connection connection, int count) {
        return () -> {
            String sql = "SELECT id ,name,addr,age from user";
            try {
                List maps = this.selectResultSet(sql, null, connection, count);
                System.out.println(JSON.toJSONString((Object)maps));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        };
    }

    public List<Map<String, Object>> readNLine(ResultSet resultSet, int nLines) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            ResultSetMetaData colinfo = resultSet.getMetaData();
            int cols = colinfo.getColumnCount();
            while (resultSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < cols; ++i) {
                    map.put(colinfo.getColumnLabel(i + 1), resultSet.getObject(i + 1));
                }
                list.add(map);
                if (nLines == 0 || list.size() != nLines) continue;
                return list;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> selectResultSet(String sql, Object[] objs, Connection con) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        PreparedStatement ps = null;
        Object resultSet = null;
        try {
            ps = con.prepareStatement(sql, 1004, 1007);
            ps.setFetchSize(1000);
            ps.setFetchDirection(1001);
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    ps.setObject(i + 1, objs[i] + "");
                }
            }
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData colinfo = rs.getMetaData();
            int cols = colinfo.getColumnCount();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < cols; ++i) {
                    map.put(colinfo.getColumnLabel(i + 1), rs.getObject(i + 1));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            this.LOGGER.error("sql\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            this.closeAll(ps, con, null);
        }
        return list;
    }

    public ResultSet getResultSet(String sql, Object[] objs, Connection con) {
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            ps = con.prepareStatement(sql, 1004, 1007);
            ps.setFetchSize(50);
            ps.setFetchDirection(1001);
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    ps.setObject(i + 1, objs[i] + "");
                }
            }
            resultSet = ps.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchExecute(String sql, List<List<Object>> objs, Connection con) throws Exception {
        con.setAutoCommit(false);
        PreparedStatement ps = null;
        int index = 0;
        try {
            ps = con.prepareStatement(sql, 1004, 1007);
            ps.setFetchSize(1000);
            ps.setFetchDirection(1001);
            if (objs != null) {
                for (int i = 0; i < objs.size(); ++i) {
                    List<Object> list = objs.get(i);
                    for (int j = 0; j < list.size(); ++j) {
                        ps.setObject(j + 1, list.get(j) + "");
                    }
                    ps.addBatch();
                    if (++index % 5000 != 0) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                    con.commit();
                }
            }
            if (index % 5000 != 0) {
                ps.executeBatch();
                con.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.closeAll(ps, con, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchExecute(String sql, List<List<Object>> objs, Conf conf) throws Exception {
        Connection con = this.getConnection(conf);
        con.setAutoCommit(false);
        PreparedStatement ps = null;
        int index = 0;
        try {
            ps = con.prepareStatement(sql, 1004, 1007);
            ps.setFetchSize(1000);
            ps.setFetchDirection(1001);
            if (objs != null) {
                for (int i = 0; i < objs.size(); ++i) {
                    List<Object> list = objs.get(i);
                    for (int j = 0; j < list.size(); ++j) {
                        ps.setObject(j + 1, list.get(j) + "");
                    }
                    ps.addBatch();
                    if (++index % 5000 != 0) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                    con.commit();
                }
            }
            if (index % 5000 != 0) {
                ps.executeBatch();
                con.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.closeAll(ps, con, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(String sql, Conf conf) throws Exception {
        Connection con = this.getConnection(conf);
        con.setAutoCommit(false);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql, 1004, 1007);
            ps.setFetchSize(1000);
            ps.setFetchDirection(1001);
            ps.execute();
            con.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.closeAll(ps, con, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(String sql, Connection con) {
        PreparedStatement ps = null;
        try {
            con.setAutoCommit(false);
            sql = sql.replaceAll("\\\\\n", "");
            ps = con.prepareStatement(sql, 1004, 1007);
            ps.setFetchSize(1000);
            ps.setFetchDirection(1001);
            ps.execute();
            con.commit();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.LOGGER.error("CommonService.executeSql \u6267\u884csql\u8bed\u53e5\u5f02\u5e38{}", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeAll(ps, con, null);
                throw throwable;
            }
            this.closeAll(ps, con, null);
        }
        this.closeAll(ps, con, null);
    }

    public long getResultDataTotal(String sql, Object[] objs, Connection con) throws SQLException {
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            ps = con.prepareStatement(sql, 1004, 1007);
            ps.setFetchSize(1000);
            ps.setFetchDirection(1000);
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    ps.setObject(i + 1, objs[i] + "");
                }
            }
            resultSet = ps.executeQuery();
            resultSet.last();
            return resultSet.getRow();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.LOGGER.error("CommonService.getResultDataTotal \u6267\u884csql\u8bed\u53e5\u5f02\u5e38{}", (Throwable)e);
            return -1L;
        }
    }

    public String generateUUID() {
        return Joiner.on((String)"_").join((Iterable)Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)DateUtils.getServerTime().replaceAll(":", "-"))) + "_" + UUID.randomUUID().toString().replaceAll("-", "");
    }
}

