/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.cache.webimpl;

import com.google.common.collect.Lists;
import io.shulie.tro.web.data.dao.user.TroUserDAO;
import io.shulie.tro.web.data.result.user.UserCacheResult;
import io.shulie.tro.web.data.result.user.UserDetailResult;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AllUserCache {
    private static final Logger log = LoggerFactory.getLogger(AllUserCache.class);
    public static final String CACHE_NAME = "t:a:c:users:all";
    @Autowired
    private TroUserDAO troUserDAO;
    @Autowired
    private RedisTemplate redisTemplate;

    @PostConstruct
    private void init() {
        this.redisTemplate.delete((Object)CACHE_NAME);
        log.info("\u6e05\u9664key:{}\u5bf9\u5e94\u7684\u7f13\u5b58\u6210\u529f", (Object)CACHE_NAME);
        this.setUserCacheFromDB();
    }

    private synchronized void setUserCacheFromDB() {
        Object cacheData = this.redisTemplate.opsForValue().get((Object)CACHE_NAME);
        if (null != cacheData) {
            return;
        }
        List userDetailResults = this.troUserDAO.selectAllUser();
        if (CollectionUtils.isEmpty((Collection)userDetailResults)) {
            this.redisTemplate.opsForValue().set((Object)CACHE_NAME, (Object)Lists.newArrayList());
            this.redisTemplate.expire((Object)CACHE_NAME, 3L, TimeUnit.MINUTES);
            return;
        }
        Map<Long, UserDetailResult> userMap = userDetailResults.stream().collect(Collectors.toMap(UserDetailResult::getId, e -> e));
        List userCaches = userDetailResults.stream().map(user -> {
            UserCacheResult userCacheResult = new UserCacheResult();
            userCacheResult.setId(user.getId());
            userCacheResult.setName(user.getName());
            userCacheResult.setKey(user.getKey());
            userCacheResult.setUserType(user.getUserType());
            userCacheResult.setCustomerId(user.getCustomerId());
            UserDetailResult customerUser = (UserDetailResult)userMap.get(user.getCustomerId());
            if (customerUser != null) {
                userCacheResult.setCustomerKey(customerUser.getKey());
            }
            return userCacheResult;
        }).collect(Collectors.toList());
        this.redisTemplate.opsForValue().set((Object)CACHE_NAME, userCaches);
        this.redisTemplate.expire((Object)CACHE_NAME, 3L, TimeUnit.MINUTES);
    }

    public UserCacheResult getCachedUserByKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException(" getCachedUserByKey , key must not null ");
        }
        List userDetailResults = (List)this.redisTemplate.opsForValue().get((Object)CACHE_NAME);
        if (userDetailResults == null) {
            this.setUserCacheFromDB();
            userDetailResults = (List)this.redisTemplate.opsForValue().get((Object)CACHE_NAME);
        }
        if (CollectionUtils.isEmpty((Collection)userDetailResults)) {
            return null;
        }
        userDetailResults.sort(Comparator.comparing(UserCacheResult::getId));
        for (UserCacheResult userDetailResult : userDetailResults) {
            if (!key.equals(userDetailResult.getKey())) continue;
            return userDetailResult;
        }
        return null;
    }

    public UserCacheResult getCachedUserById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException(" getCachedUserById , id must not null ");
        }
        List userDetailResults = (List)this.redisTemplate.opsForValue().get((Object)CACHE_NAME);
        if (userDetailResults == null) {
            this.setUserCacheFromDB();
            userDetailResults = (List)this.redisTemplate.opsForValue().get((Object)CACHE_NAME);
        }
        if (CollectionUtils.isEmpty((Collection)userDetailResults)) {
            return null;
        }
        return userDetailResults.stream().filter(user -> id.equals(user.getId())).findFirst().orElse(null);
    }

    public UserCacheResult getCachedUserByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException(" getCachedUserByName , name must not empty ");
        }
        List userDetailResults = (List)this.redisTemplate.opsForValue().get((Object)CACHE_NAME);
        if (userDetailResults == null) {
            this.setUserCacheFromDB();
            userDetailResults = (List)this.redisTemplate.opsForValue().get((Object)CACHE_NAME);
        }
        if (CollectionUtils.isEmpty((Collection)userDetailResults)) {
            return null;
        }
        return userDetailResults.stream().filter(user -> name.equals(user.getName())).findFirst().orElse(null);
    }
}

