/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.cache;

import io.shulie.tro.web.app.cache.AgentCacheSupport;
import io.shulie.tro.web.app.common.RestContext;
import java.util.Collection;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class AbstractAgentConfigCache<T>
implements AgentCacheSupport<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAgentConfigCache.class);
    private final String cacheName;
    private final RedisTemplate redisTemplate;

    public AbstractAgentConfigCache(String cacheName, RedisTemplate redisTemplate) {
        this.cacheName = cacheName;
        this.redisTemplate = redisTemplate;
    }

    public T get(String namespace) {
        Object result = this.redisTemplate.opsForValue().get((Object)this.getCacheKey(namespace));
        if (result == null) {
            result = this.queryValue(namespace);
            this.redisTemplate.opsForValue().set((Object)this.getCacheKey(namespace), result);
        }
        return (T)result;
    }

    public void evict(String namespace) {
        this.redisTemplate.delete((Object)this.getCacheKey(namespace));
    }

    @PostConstruct
    private void reset() {
        Set keys;
        String beClearKey = this.cacheName + "*";
        if (!"*".equals(beClearKey) && CollectionUtils.isNotEmpty((Collection)(keys = this.redisTemplate.keys((Object)beClearKey)))) {
            keys.forEach(key -> this.redisTemplate.delete(key));
            log.info("\u6e05\u9664key:{}\u5bf9\u5e94\u7684\u7f13\u5b58\u6210\u529f", (Object)beClearKey);
        }
    }

    private String getCacheKey(String namespace) {
        String key = this.cacheName + ":" + RestContext.getUser().getCustomerId();
        if (namespace != null) {
            key = key + ":";
            key = key + namespace;
        }
        return key;
    }

    protected abstract T queryValue(String var1);
}

