/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.aspect;

import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.holder.OperationMessageHolder;
import io.shulie.tro.web.app.request.log.OperationLogCreateRequest;
import io.shulie.tro.web.app.service.log.OperationLogService;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OperationLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OperationLogAspect.class);
    @Autowired
    private OperationLogService operationLogService;

    @Pointcut(value="@annotation(io.shulie.tro.common.beans.annotation.ModuleDef)")
    private void controllerAspect() {
    }

    @Before(value="controllerAspect()")
    public void doBefore() {
        OperationLogContextHolder.reset();
        OperationLogContextHolder.start();
    }

    @AfterReturning(value="controllerAspect()")
    public void doAfter(JoinPoint jp) {
        OperationLogContextHolder.end((boolean)true);
        this.record(jp);
    }

    @AfterThrowing(value="controllerAspect()")
    public void doAfterThrow(JoinPoint jp) {
        OperationLogContextHolder.end((boolean)false);
    }

    private void record(JoinPoint jp) {
        if (OperationLogContextHolder.get().getIgnore().booleanValue()) {
            return;
        }
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        ModuleDef annotation = targetMethod.getAnnotation(ModuleDef.class);
        String message = OperationMessageHolder.formatMessage((String)annotation.logMsgKey(), (Map)OperationLogContextHolder.get().getVars());
        String moduleName = annotation.moduleName();
        String subModuleName = annotation.subModuleName();
        String operType = OperationLogContextHolder.get().getOperationType();
        if (operType == null) {
            operType = "-";
        }
        Boolean status = OperationLogContextHolder.get().getSuccess();
        long startTimeMills = OperationLogContextHolder.get().getStartTime();
        long stopTimeMills = OperationLogContextHolder.get().getEndTime();
        Long userId = RestContext.getUser().getId();
        String userName = RestContext.getUser().getName();
        OperationLogCreateRequest createRequest = new OperationLogCreateRequest();
        createRequest.setModule(moduleName);
        createRequest.setSubModule(subModuleName);
        createRequest.setType(operType);
        createRequest.setStatus(status != false ? "\u6210\u529f" : "\u5931\u8d25");
        createRequest.setContent(message);
        createRequest.setUserId(userId);
        createRequest.setUserName(userName);
        createRequest.setStartTime(new Date(startTimeMills));
        createRequest.setEndTime(new Date(stopTimeMills));
        this.operationLogService.record(createRequest);
    }
}

