/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.aspect;

import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.common.constant.RemoteConstant;
import io.shulie.tro.web.common.domain.WebRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LicenseAspect {
    private static final Logger log = LoggerFactory.getLogger(LicenseAspect.class);
    @Value(value="${tro.cloud.url}")
    private String remoteUrl;

    @Pointcut(value="execution(public * io.shulie.tro.web.common.http.HttpWebClient.request*(..))")
    public void setLicense() {
    }

    @Before(value="setLicense()")
    public void doBefore(JoinPoint joinPoint) {
        Object[] params = joinPoint.getArgs();
        if (params != null && params.length == 1 && params[0] instanceof WebRequest) {
            Long uid;
            WebRequest inParam = (WebRequest)params[0];
            inParam.setRequestUrl(this.remoteUrl + inParam.getRequestUrl());
            inParam.setLicense(RemoteConstant.LICENSE_VALUE);
            Long l = uid = RestContext.getUser() != null ? RestContext.getUser().getId() : null;
            if (uid == null) {
                uid = inParam.getUid();
            }
            inParam.setUid(uid);
            inParam.setFilterUids(RestContext.getQueryAllowUserIdList());
        }
    }
}

