/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.aspect;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pamirs.tro.entity.dao.auth.TUserDeptRelationMapper;
import com.pamirs.tro.entity.domain.entity.auth.TreeConvertUtil;
import com.pamirs.tro.entity.domain.entity.user.DeptUser;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.aspect.DataQueryAuthVerificationAspect;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.service.auth.impl.TroAuthServiceImpl;
import io.shulie.tro.web.app.utils.TroUserUtil;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.auth.api.enums.DataTypeEnum;
import io.shulie.tro.web.auth.api.exception.TroAuthException;
import io.shulie.tro.web.data.result.user.DeptQueryResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class DataQueryAuthVerificationAspect {
    private static final Logger log = LoggerFactory.getLogger(DataQueryAuthVerificationAspect.class);
    @Autowired
    private TUserDeptRelationMapper tUserDeptRelationMapper;

    @Pointcut(value="@annotation(io.shulie.tro.web.app.annotation.AuthVerification)")
    private void controllerAspect() {
    }

    @Before(value="controllerAspect()")
    public void doBefore(JoinPoint joinPoint) {
        RestContext.setEmptyAuth();
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        AuthVerification annotation = targetMethod.getAnnotation(AuthVerification.class);
        String moduleCode = annotation.moduleCode();
        User user = RestContext.getUser();
        if (!Objects.isNull(user)) {
            if (TroUserUtil.validateSuperAdmin((User)user).booleanValue()) {
                RestContext.clearAuth();
                return;
            }
            Map dataMap = user.getPermissionData();
            block16: for (ActionTypeEnum actionTypeEnum : ActionTypeEnum.values()) {
                String key = moduleCode + "_" + actionTypeEnum.getCode() + "_" + actionTypeEnum.name().toLowerCase();
                if (!dataMap.containsKey(key)) continue;
                List scopeList = (List)dataMap.get(key);
                if (CollectionUtils.isEmpty((Collection)scopeList)) {
                    String msg = "\u7528\u6237\u6682\u672a\u5206\u914d\u6570\u636e\u6743\u9650\uff1a" + user.getId();
                    log.warn(msg);
                    continue;
                }
                if (scopeList.contains(DataTypeEnum.ALL.getCode())) {
                    switch (1.$SwitchMap$io$shulie$tro$web$auth$api$enums$ActionTypeEnum[actionTypeEnum.ordinal()]) {
                        case 1: {
                            RestContext.queryAllowUserIdListThreadLocal.remove();
                            break;
                        }
                        case 2: {
                            RestContext.updateAllowUserIdListThreadLocal.remove();
                            break;
                        }
                        case 3: {
                            RestContext.deleteAllowUserIdListThreadLocal.remove();
                            break;
                        }
                        case 4: {
                            RestContext.enableDisableAllowUserIdListThreadLocal.remove();
                            break;
                        }
                        case 5: {
                            RestContext.startStopAllowUserIdListThreadLocal.remove();
                            break;
                        }
                        case 6: {
                            RestContext.downloadAllowUserIdListThreadLocal.remove();
                            break;
                        }
                    }
                    continue;
                }
                List deptQueryResultList = user.getDeptList();
                if (CollectionUtils.isEmpty((Collection)deptQueryResultList)) {
                    String msg = "\u7528\u6237\u65e0\u6240\u5c5e\u90e8\u95e8\uff0c\u67e5\u8be2\u6570\u636e\u6743\u9650\u5931\u8d25\uff1a" + user.getId();
                    log.warn(msg);
                    throw new TroAuthException((ExceptionReadable)ExceptionCode.DATA_PERMISSION_DENY_ERROR, (Object)msg);
                }
                Long userIdParam = null;
                List deptList = deptQueryResultList;
                Set currentDeptIdList = deptList.stream().map(DeptQueryResult::getId).map(String::valueOf).collect(Collectors.toSet());
                ArrayList deptIdList = Lists.newArrayList();
                if (scopeList.contains(DataTypeEnum.CURRENT_DEPT.getCode()) || scopeList.contains(DataTypeEnum.CURRENT_DEPT_AND_LESS.getCode())) {
                    deptIdList.addAll(currentDeptIdList);
                }
                if (scopeList.contains(DataTypeEnum.CURRENT_DEPT_AND_LESS.getCode()) || scopeList.contains(DataTypeEnum.SELF_AND_DEPT_LESS.getCode())) {
                    deptIdList.addAll(this.getSubDeptIdList(currentDeptIdList));
                }
                if (scopeList.contains(DataTypeEnum.SELF_AND_DEPT_LESS.getCode()) || scopeList.contains(DataTypeEnum.SELF.getCode())) {
                    userIdParam = user.getId();
                }
                List scopeUserList = this.tUserDeptRelationMapper.selectUserIdByScope((List)deptIdList, userIdParam);
                List allowUserIdList = scopeUserList.stream().map(DeptUser::getId).collect(Collectors.toList());
                switch (1.$SwitchMap$io$shulie$tro$web$auth$api$enums$ActionTypeEnum[actionTypeEnum.ordinal()]) {
                    case 1: {
                        RestContext.setQueryAllowUserIdList(allowUserIdList.stream().distinct().collect(Collectors.toList()));
                        continue block16;
                    }
                    case 2: {
                        RestContext.setUpdateAllowUserIdList(allowUserIdList.stream().distinct().collect(Collectors.toList()));
                        continue block16;
                    }
                    case 3: {
                        RestContext.setDeleteAllowUserIdList(allowUserIdList.stream().distinct().collect(Collectors.toList()));
                        continue block16;
                    }
                    case 4: {
                        RestContext.setEnableDisableAllowUserIdList(allowUserIdList.stream().distinct().collect(Collectors.toList()));
                        continue block16;
                    }
                    case 5: {
                        RestContext.setStartStopAllowUserIdList(allowUserIdList.stream().distinct().collect(Collectors.toList()));
                        continue block16;
                    }
                    case 6: {
                        RestContext.setDownloadAllowUserIdList(allowUserIdList.stream().distinct().collect(Collectors.toList()));
                        continue block16;
                    }
                }
            }
        }
    }

    private List<String> getSubDeptIdList(Set<String> deptIdSet) {
        HashSet lowerDeptIdSet = Sets.newHashSet();
        TreeConvertUtil.getLowerDeptByParentDeptIds((List)TroAuthServiceImpl.deptTotalList, deptIdSet, (Set)lowerDeptIdSet);
        lowerDeptIdSet.removeAll(deptIdSet);
        return new ArrayList<String>(lowerDeptIdSet);
    }
}

