/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.aspect;

import io.shulie.tro.cloud.open.req.HttpCloudRequest;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.common.constant.RemoteConstant;
import io.shulie.tro.web.common.util.FilterSqlUtil;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CloudApiAspect {
    private static final Logger log = LoggerFactory.getLogger(CloudApiAspect.class);

    @Pointcut(value="execution(public * io.shulie.tro.web.diff.cloud.impl..*.*(..))")
    public void myAspect() {
    }

    @Before(value="myAspect()")
    public void doBefore(JoinPoint joinPoint) {
        Object[] params = joinPoint.getArgs();
        if (params != null && params.length == 1 && params[0] instanceof HttpCloudRequest) {
            HttpCloudRequest inParam = (HttpCloudRequest)params[0];
            inParam.setLicense(RemoteConstant.LICENSE_VALUE);
            inParam.setUid(RestContext.getUser() != null ? RestContext.getUser().getId() : null);
            String filterSql = FilterSqlUtil.buildFilterSql((List)RestContext.getQueryAllowUserIdList());
            if (filterSql != null) {
                inParam.setFilterSql(filterSql);
            }
        }
    }
}

