/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.aspect;

import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.constant.BizOpConstants;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.auth.api.exception.TroAuthException;
import io.shulie.tro.web.common.constant.TroClientAuthConstant;
import java.lang.reflect.Method;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=0)
public class ActionAuthVerificationAspect {
    private static final Logger log = LoggerFactory.getLogger(ActionAuthVerificationAspect.class);

    @Pointcut(value="@annotation(io.shulie.tro.web.app.annotation.AuthVerification)")
    private void controllerAspect() {
    }

    @Before(value="controllerAspect()")
    public void doBefore(JoinPoint jp) throws TroAuthException {
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        AuthVerification annotation = targetMethod.getAnnotation(AuthVerification.class);
        String moduleCode = annotation.moduleCode();
        ActionTypeEnum actionTypeEnum = annotation.needAuth();
        if (!actionTypeEnum.equals((Object)ActionTypeEnum.QUERY) && TroClientAuthConstant.isExpire.booleanValue()) {
            String msg = "license\u8fc7\u671f\uff0c\u65e0\u8be5\u64cd\u4f5c\u6743\u9650\uff1a" + actionTypeEnum.name();
            throw new TroAuthException((ExceptionReadable)ExceptionCode.LICENSE_PERMISSION_DENY_ERROR, (Object)msg);
        }
        User user = RestContext.getUser();
        if (user.getUserType() == 0) {
            return;
        }
        Map permisstionActionMap = user.getPermissionAction();
        Map permisstionMenuMap = user.getPermissionMenu();
        if (actionTypeEnum.getCode().equals(ActionTypeEnum.QUERY.getCode())) {
            if (!permisstionMenuMap.containsKey(moduleCode)) {
                String msg = BizOpConstants.modelNameMap.containsKey(moduleCode) ? "\u83dc\u5355\u6743\u9650\u4e0d\u8db3\uff1a\u3010" + (String)BizOpConstants.modelNameMap.get(moduleCode) + "\u3011,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406" : "\u83dc\u5355\u6743\u9650\u4e0d\u8db3\uff1a" + moduleCode;
                log.error(msg);
                ExceptionCode.MENU_PERMISSION_DENY_ERROR.setDefaultValue(msg);
                throw new TroAuthException((ExceptionReadable)ExceptionCode.MENU_PERMISSION_DENY_ERROR, (Object)msg);
            }
        } else {
            String key = moduleCode + "_" + actionTypeEnum.getCode() + "_" + actionTypeEnum.name().toLowerCase();
            if (!permisstionActionMap.containsKey(key)) {
                String msg = "\u64cd\u4f5c\u6743\u9650\u4e0d\u8db3\uff1a" + actionTypeEnum.name();
                log.error(msg);
                ExceptionCode.ACTION_PERMISSION_DENY_ERROR.setDefaultValue(msg);
                throw new TroAuthException((ExceptionReadable)ExceptionCode.ACTION_PERMISSION_DENY_ERROR, (Object)msg);
            }
        }
    }
}

