/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.agent;

import com.google.common.collect.Sets;
import io.shulie.tro.channel.ServerChannel;
import io.shulie.tro.channel.bean.CommandPacket;
import io.shulie.tro.channel.bean.CommandRespType;
import io.shulie.tro.channel.bean.CommandResponse;
import io.shulie.tro.channel.bean.CommandSend;
import io.shulie.tro.channel.bean.CommandStatus;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.agent.AgentCommandEnum;
import io.shulie.tro.web.app.agent.AgentCommandFactory;
import io.shulie.tro.web.app.agent.TroWebCommandPacket;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.common.future.ResponseFuture;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class AgentCommandFactory {
    private static final Logger log = LoggerFactory.getLogger(AgentCommandFactory.class);
    @Autowired
    private ServerChannel serverChannel;
    @Autowired
    private RedisTemplate redisTemplate;
    private String agentKey = "%s:%s:%s:%s";
    @Value(value="${agent.interactive.tro.web.url:http://192.168.1.107:10086/tro-web}")
    private String troWebUrl;

    public CommandResponse send(AgentCommandEnum commandEnum, String agentId, Map<String, Object> params) throws Exception {
        TroWebCommandPacket troPacket = this.getSendPacket(commandEnum, agentId, params);
        this.checkPacket(troPacket);
        String key = String.format(this.agentKey, troPacket.getAgentId(), troPacket.getSend().getCommand(), troPacket.getSend().getModuleId(), troPacket.getId());
        ResponseFuture future = new ResponseFuture(troPacket.getTimeoutMillis() == null ? 3000L : troPacket.getTimeoutMillis());
        CommandPacket commandPacket = new CommandPacket();
        BeanUtils.copyProperties((Object)troPacket, (Object)commandPacket);
        boolean sendResult = false;
        try {
            sendResult = this.serverChannel.send(commandPacket, arg_0 -> ((ResponseFuture)future).success(arg_0));
        }
        catch (Exception e) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_SEND_ERROR, (Object)("agentId\uff1a" + troPacket.getAgentId() + "\u4e0a\u4f20\u547d\u4ee4\u5931\u8d25\uff1a" + e.getLocalizedMessage()));
        }
        if (!sendResult) {
            log.error("send command failed, serverChannel.send got a false result ...");
            throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_REGISTER_ERROR, (Object)("agentId\uff1a" + troPacket.getAgentId() + "\u672a\u6ce8\u518c"));
        }
        CommandPacket result = null;
        try {
            result = (CommandPacket)future.waitFor();
        }
        catch (InterruptedException e) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_SEND_ERROR, (Object)("agentId\uff1a" + troPacket.getAgentId() + "\u83b7\u53d6\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + e.getLocalizedMessage()));
        }
        if (CommandRespType.COMMAND_HTTP_PUSH.equals((Object)troPacket.getCommandRespType())) {
            return CommandResponse.success((Object)("\u8fd4\u56de\u6570\u636e\u81f3" + troPacket.getResponsePushUrl()));
        }
        if (result == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_RESPONSE_ERROR, (Object)("agentId\uff1a" + troPacket.getAgentId() + "\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a"));
        }
        CommandStatus commandStatus = result.getStatus();
        String commandModule = commandPacket.getSend().getModuleId();
        switch (1.$SwitchMap$io$shulie$tro$channel$bean$CommandStatus[commandStatus.ordinal()]) {
            case 1: {
                log.error("execute command error. no response for this command [{}]:", (Object)commandModule);
                this.redisTemplate.opsForValue().set((Object)key, (Object)CommandStatus.COMMAND_SEND);
                throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_RESPONSE_ERROR, (Object)("agentId\uff1a" + troPacket.getAgentId() + "\u6267\u884c" + commandModule + "\u8d85\u8fc7" + troPacket.getTimeoutMillis() + "\u672a\u5f97\u5230agent\u54cd\u5e94"));
            }
            case 2: {
                log.error("execute command error. execute [{}] command timeout: " + commandModule);
                this.redisTemplate.opsForValue().set((Object)key, (Object)CommandStatus.COMMAND_RUNNING);
                throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_RESPONSE_ERROR, (Object)("agentId\uff1a" + troPacket.getAgentId() + "\u6267\u884c" + commandModule + "\u8d85\u65f6" + troPacket.getTimeoutMillis()));
            }
            case 3: {
                log.error("execute command error. execute [{}] command failed: " + commandModule);
                throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_RESPONSE_ERROR, (Object)("agentId\uff1a" + troPacket.getAgentId() + "\u6267\u884c" + commandModule + "\u5931\u8d25"));
            }
            case 4: {
                log.info("execute command success. execute [{}] command success: " + commandModule);
                return result.getResponse();
            }
        }
        throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_RESPONSE_ERROR, (Object)("agentId\uff1a" + troPacket.getAgentId() + "\u54cd\u5e94\u5931\u8d25"));
    }

    private TroWebCommandPacket getSendPacket(AgentCommandEnum commandEnum, String agentId, Map<String, Object> params) {
        CommandSend commandSend = new CommandSend();
        commandSend.setModuleId(commandEnum.getModuleId());
        commandSend.setCommand(commandEnum.getCommand());
        commandSend.setAgentId(agentId);
        commandSend.setCommandId(commandEnum.getCommandId());
        if (params != null) {
            commandSend.setParam(params);
        }
        TroWebCommandPacket troWebCommandPacket = new TroWebCommandPacket();
        troWebCommandPacket.setStatus(CommandStatus.COMMAND_SEND);
        troWebCommandPacket.setSend(commandSend);
        troWebCommandPacket.setId(UUID.randomUUID().toString());
        troWebCommandPacket.setCommandRespType(commandEnum.getCommandRespType());
        if (StringUtils.isNotBlank((CharSequence)commandEnum.getResponsePushUrl())) {
            troWebCommandPacket.setResponsePushUrl(this.troWebUrl + commandEnum.getResponsePushUrl());
        }
        troWebCommandPacket.setAgentId(agentId);
        if (commandEnum.getTimeoutMillis() != null) {
            troWebCommandPacket.setTimeoutMillis(commandEnum.getTimeoutMillis());
        }
        troWebCommandPacket.setIsAllowMultipleExecute(commandEnum.getIsAllowMultipleExecute());
        return troWebCommandPacket;
    }

    private void checkPacket(TroWebCommandPacket troWebPacket) {
        Set keys;
        if (!troWebPacket.getIsAllowMultipleExecute().booleanValue() && (keys = this.keys(String.format(this.agentKey, troWebPacket.getAgentId(), troWebPacket.getSend().getCommand(), troWebPacket.getSend().getModuleId(), "*"))).size() > 0) {
            for (String agentKey : keys) {
                CommandStatus commandStatus = null;
                try {
                    String[] temp = agentKey.split(":");
                    CommandPacket commandPacket = this.serverChannel.getCurrentCommand(temp[0], temp[temp.length - 1]);
                    commandStatus = Optional.ofNullable(commandPacket).map(CommandPacket::getStatus).orElse(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (commandStatus == null) continue;
                if (CommandStatus.COMMAND_COMPLETED_SUCCESS.equals(commandStatus) || CommandStatus.COMMAND_COMPLETED_FAIL.equals(commandStatus)) {
                    this.redisTemplate.delete((Object)agentKey);
                    continue;
                }
                log.error("send command failed,\u547d\u4ee4{} serverChannel.send not allow multiple execute", (Object)troWebPacket.getSend().getModuleId());
                throw new TroWebException((ExceptionReadable)ExceptionCode.AGENT_SEND_ERROR, (Object)("agentId\uff1a" + troWebPacket.getAgentId() + ",\u547d\u4ee4" + troWebPacket.getSend().getModuleId() + "\u4e0d\u5141\u8bb8\u591a\u6b21\u6267\u884c"));
            }
        }
    }

    public Set<String> keys(String pattern) {
        HashSet keys = Sets.newHashSet();
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            keys.add(key);
        });
        return keys;
    }

    private void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(connection -> {
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());){
                cursor.forEachRemaining(consumer);
                Object var5_6 = null;
                return var5_6;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }
}

