/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.cloud.app.intercepter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import io.shulie.tro.cloud.common.context.LoginUser;
import io.shulie.tro.cloud.common.context.RestContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoginInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.checkEnvTest(request).booleanValue()) {
            return true;
        }
        LoginUser user = RestContext.getUser();
        if (user != null) {
            return true;
        }
        log.error("\u7528\u6237\u672a\u767b\u5f55");
        this.printNotLogin(response);
        return false;
    }

    private void printNotLogin(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        PrintWriter printWriter = null;
        try {
            printWriter = response.getWriter();
            HashMap map = Maps.newHashMap();
            map.put("msg", "\u672a\u767b\u9646\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
            map.put("status", HttpStatus.UNAUTHORIZED.value());
            String s = JSON.toJSONString((Object)map);
            printWriter.write(s);
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Boolean checkEnvTest(HttpServletRequest request) {
        String env = request.getHeader("Env");
        if (StringUtils.equals((CharSequence)"localTest", (CharSequence)env)) {
            return true;
        }
        return false;
    }
}

