/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.cloud.app.intercepter;

import com.alibaba.fastjson.JSON;
import io.shulie.tro.common.beans.response.ResponseResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerInterceptor;

@Service
public class AuthorityInterceptor
implements HandlerInterceptor {
    private static final String REDIS_LOGIN_KEY = "login_key";
    private static final String specialToken = "123456789101112";
    private final Logger log = LoggerFactory.getLogger(AuthorityInterceptor.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Value(value="${spring.profiles.active}")
    private String env;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.env) && "dev".equals(this.env)) {
            return true;
        }
        String sessionId = request.getRequestedSessionId();
        String refer = request.getHeader("Referer");
        if (Objects.nonNull(refer) && refer.contains(specialToken)) {
            return true;
        }
        try {
            Cookie[] cookies;
            Long endTime;
            long overdueTime;
            String tokenTime;
            String[] split;
            String token;
            Object obj;
            if (StringUtils.isBlank((CharSequence)sessionId)) {
                this.writeResponse(response, "300", "sessionId is null");
            }
            if (Objects.isNull(obj = this.redisTemplate.opsForHash().get((Object)REDIS_LOGIN_KEY, (Object)sessionId))) {
                this.writeResponse(response, "300", String.format("redis key:%s get is null", sessionId));
            }
            if (StringUtils.isBlank((CharSequence)(token = (split = (tokenTime = String.valueOf(obj)).split(":"))[0])) && null == split[1]) {
                this.writeResponse(response, "300", String.format("redis get token:%s || time:%s is null", token, split[1]));
            }
            if ((overdueTime = (endTime = Long.valueOf(split[1])) - System.currentTimeMillis()) < 1L) {
                this.writeResponse(response, "300", String.format("login is overdue : %s", overdueTime));
            }
            for (Cookie cookie : cookies = request.getCookies()) {
                if (!Objects.equals(token, cookie.getValue())) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void writeResponse(HttpServletResponse response, String code, String msg) throws IOException {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("type", "opaqueredirect");
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        ResponseResult result = ResponseResult.fail((String)code, (String)msg, (String)"opaqueredirect");
        writer.write(JSON.toJSONString((Object)result));
        writer.flush();
        writer.close();
    }
}

