/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.cloud.app.init;

import com.alibaba.fastjson.JSON;
import com.pamirs.tro.entity.dao.cloudserver.TCloudPlatformMapper;
import com.pamirs.tro.entity.domain.entity.cloudserver.CloudPlatform;
import com.pamirs.tro.entity.domain.query.CloudPlatformQueryParam;
import io.shulie.flpt.core.plugin.CloudServerPlugin;
import io.shulie.tro.cloud.common.utils.FileUtils;
import io.shulie.tro.cloud.common.utils.LinuxUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CloudSdkLoader {
    public static final Map<String, CloudServerPlugin> CLOUD_PLUGINS = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(CloudSdkLoader.class);
    @Value(value="${pradar_cloud_sdk_path}")
    private String SDK_PATH;
    @Resource
    private TCloudPlatformMapper TCloudPlatformMapper;

    public void loadSDK() {
        CLOUD_PLUGINS.clear();
        List pluginJarFiles = FileUtils.getDirectoryFiles((String)this.SDK_PATH, (String)".jar");
        if (pluginJarFiles == null || pluginJarFiles.isEmpty()) {
            logger.warn("No plugin found for cloud SDK");
            return;
        }
        CloudPlatformQueryParam queryParam = new CloudPlatformQueryParam();
        List cloudPlatforms = this.TCloudPlatformMapper.selectByExample(queryParam);
        if (cloudPlatforms == null || cloudPlatforms.size() == 0) {
            logger.warn("No cloud platform in db !");
            return;
        }
        HashMap<String, String> cloudNameJarMap = new HashMap<String, String>();
        for (CloudPlatform platform : cloudPlatforms) {
            if (!StringUtils.isNotBlank((CharSequence)platform.getJarName())) continue;
            cloudNameJarMap.put(platform.getJarName(), platform.getName());
        }
        try {
            for (File file : pluginJarFiles) {
                String jarPath = file.getCanonicalPath();
                String jarName = file.getName();
                if (!cloudNameJarMap.containsKey(jarName)) continue;
                String urlStr = "file:" + jarPath;
                this.initSDK(null, (String)cloudNameJarMap.get(jarName), null, urlStr);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initSDK(Long id, String cloudName, String jarName, String urlStr) {
        try {
            URL[] urls = new URL[]{new URL(urlStr)};
            ServiceLoader<CloudServerPlugin> serviceLoader = null;
            try {
                URLClassLoader urlClassLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
                serviceLoader = ServiceLoader.load(CloudServerPlugin.class, urlClassLoader);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            if (serviceLoader != null) {
                for (CloudServerPlugin plugin : serviceLoader) {
                    CLOUD_PLUGINS.put(cloudName, plugin);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316sdk \u53d1\u751f\u90e8\u5206\u5931\u8d25", (Throwable)e);
        }
    }

    public void loadJar(Long id, String cloudName, String jarname, String urlStr, Boolean initPlatform) throws Exception {
        URL[] urls = new URL[]{new URL(urlStr)};
        URLClassLoader urlClassLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        ServiceLoader<CloudServerPlugin> serviceLoader = ServiceLoader.load(CloudServerPlugin.class, urlClassLoader);
        Iterator<CloudServerPlugin> iterator = serviceLoader.iterator();
        if (!iterator.hasNext()) {
            if (StringUtils.isNotBlank((CharSequence)jarname) && StringUtils.isNotBlank((CharSequence)this.SDK_PATH)) {
                String jarPath = this.SDK_PATH + "/" + jarname;
                LinuxUtil.executeLinuxCmd((String)(" rm -rf " + jarPath));
            }
            throw new RuntimeException("\u4e0a\u4f20\u7684jar\u4e0d\u7b26\u5408\u8981\u6c42\uff01");
        }
        while (iterator.hasNext()) {
            CloudPlatform dbPlatform;
            CloudServerPlugin plugin = iterator.next();
            CLOUD_PLUGINS.put(cloudName, plugin);
            if (!initPlatform.booleanValue()) continue;
            CloudPlatformQueryParam param = new CloudPlatformQueryParam();
            if (id != null) {
                param.setId(id);
            } else if (cloudName != null) {
                param.setName(cloudName);
            }
            List cloudPlatforms = this.TCloudPlatformMapper.selectByExample(param);
            if (cloudPlatforms == null || cloudPlatforms.size() == 0) {
                dbPlatform = new CloudPlatform();
                dbPlatform.setName(plugin.getCloudServerName());
                if (plugin.getAuthorizeParam() != null) {
                    dbPlatform.setAuthorizeParam(JSON.toJSONString((Object)plugin.getAuthorizeParam()));
                }
                dbPlatform.setClassPath(plugin.getClass().getName());
                dbPlatform.setJarName(jarname);
                dbPlatform.setName(cloudName);
                this.TCloudPlatformMapper.insertSelective(dbPlatform);
                continue;
            }
            dbPlatform = (CloudPlatform)cloudPlatforms.get(0);
            CloudPlatform updatePlatform = new CloudPlatform();
            updatePlatform.setId(dbPlatform.getId());
            if (plugin.getAuthorizeParam() != null) {
                updatePlatform.setAuthorizeParam(JSON.toJSONString((Object)plugin.getAuthorizeParam()));
            }
            updatePlatform.setClassPath(plugin.getClass().getName());
            updatePlatform.setJarName(jarname);
            if (StringUtils.isNotBlank((CharSequence)cloudName)) {
                updatePlatform.setName(cloudName);
            }
            this.TCloudPlatformMapper.updateByPrimaryKeySelective(updatePlatform);
        }
    }
}

