/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.cloud.app.filter;

import com.google.common.base.Preconditions;
import com.pamirs.tro.entity.domain.vo.cloudserver.BigFileUploadVO;
import io.shulie.tro.cloud.biz.service.cloudServer.BigFileService;
import io.shulie.tro.cloud.common.utils.HttpUtils;
import io.shulie.tro.common.beans.response.ResponseResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BigfileUploadFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(BigfileUploadFilter.class);
    @Autowired(required=false)
    private BigFileService bigFileService;

    public static final byte[] input2byte(InputStream inStream, int byteLength) throws IOException {
        byte[] bytes = BigfileUploadFilter.toByteArray((InputStream)inStream, (int)byteLength);
        return bytes;
    }

    public static byte[] toByteArray(InputStream in, int byteLength) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(0x600000);
        long start = System.currentTimeMillis();
        BigfileUploadFilter.copy((InputStream)in, (OutputStream)out, (int)byteLength);
        logger.info("copy cost : " + (System.currentTimeMillis() - start) + " ms");
        return out.toByteArray();
    }

    public static long copy(InputStream from, OutputStream to, int byteLength) throws IOException {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        byte[] buf = new byte[0x100000];
        long total = 0L;
        int r;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURI = request.getRequestURI();
        if (requestURI.equals("/tro-web/api/bigfile/upload")) {
            ResponseResult result = null;
            String license = request.getHeader("license");
            String sceneId = request.getHeader("sceneId");
            String fileName = request.getHeader("fileName");
            String startPos = request.getHeader("startPos");
            String byteLength = request.getHeader("byteLength");
            if (license == null || sceneId == null || fileName == null) {
                result = ResponseResult.fail((String)"license | sceneId | fileName can not be null", (String)"");
                HttpUtils.writeResponse((HttpServletResponse)response, (String)"0", (ResponseResult)result, null);
            }
            if (byteLength == null) {
                byteLength = "0";
            }
            ServletInputStream inputStream = request.getInputStream();
            BigFileUploadVO param = new BigFileUploadVO();
            param.setByteData(BigfileUploadFilter.input2byte((InputStream)inputStream, (int)Integer.valueOf(byteLength)));
            param.setFileName(fileName);
            param.setLicense(license);
            param.setSceneId(Long.valueOf(sceneId));
            if (startPos != null) {
                param.setStartPos(Long.valueOf(startPos));
            }
            logger.info("filter receive data ....");
            result = this.bigFileService.upload(license, param);
            logger.info("result :{}", (Object)result.getSuccess());
            HttpUtils.writeResponse((HttpServletResponse)response, (String)"0", (ResponseResult)result, (InputStream)inputStream);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }
}

