/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.cloud.app.conf;

import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class})})
public class SqlCostInterceptor
implements Interceptor {
    private final Logger LOGGER = LoggerFactory.getLogger(SqlCostInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object object;
        Object target = invocation.getTarget();
        long startTime = System.currentTimeMillis();
        StatementHandler statementHandler = (StatementHandler)target;
        try {
            object = invocation.proceed();
        }
        catch (Throwable throwable) {
            long endTime = System.currentTimeMillis();
            long sqlCost = endTime - startTime;
            BoundSql boundSql = statementHandler.getBoundSql();
            String sql = boundSql.getSql();
            Object parameterObject = boundSql.getParameterObject();
            List parameterMappingList = boundSql.getParameterMappings();
            sql = this.formatSql(sql, parameterObject, parameterMappingList);
            System.out.println("SQL\uff1a[" + sql + "]\u6267\u884c\u8017\u65f6[" + sqlCost + "ms]");
            this.LOGGER.info(String.format("\u6267\u884c\u7684SQL\u8bed\u53e5\u4e3a: %s,\u6267\u884c\u8017\u65f6\u4e3a: %s ms", sql, sqlCost));
            throw throwable;
        }
        long endTime = System.currentTimeMillis();
        long sqlCost = endTime - startTime;
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = boundSql.getSql();
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappingList = boundSql.getParameterMappings();
        sql = this.formatSql(sql, parameterObject, parameterMappingList);
        System.out.println("SQL\uff1a[" + sql + "]\u6267\u884c\u8017\u65f6[" + sqlCost + "ms]");
        this.LOGGER.info(String.format("\u6267\u884c\u7684SQL\u8bed\u53e5\u4e3a: %s,\u6267\u884c\u8017\u65f6\u4e3a: %s ms", sql, sqlCost));
        return object;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private String formatSql(String sql, Object parameterObject, List<ParameterMapping> parameterMappingList) {
        if (sql == null || sql.length() == 0) {
            return "";
        }
        sql = this.beautifySql(sql);
        if (parameterObject == null || parameterMappingList == null || parameterMappingList.size() == 0) {
            return sql;
        }
        String sqlWithoutReplacePlaceholder = sql;
        try {
            if (parameterMappingList != null) {
                Class<?> parameterObjectClass = parameterObject.getClass();
                if (this.isStrictMap(parameterObjectClass)) {
                    DefaultSqlSession.StrictMap strictMap = (DefaultSqlSession.StrictMap)parameterObject;
                    if (this.isList(((Collection)strictMap.get((Object)"list")).getClass())) {
                        sql = this.handleListParameter(sql, (Collection)strictMap.get((Object)"list"));
                    }
                } else if (this.isMap(parameterObjectClass)) {
                    Map paramMap = (Map)parameterObject;
                    sql = this.handleMapParameter(sql, paramMap, parameterMappingList);
                } else {
                    sql = this.handleCommonParameter(sql, parameterMappingList, parameterObjectClass, parameterObject);
                }
            }
        }
        catch (Exception e) {
            return sqlWithoutReplacePlaceholder;
        }
        return sql;
    }

    private String beautifySql(String sql) {
        sql = sql.replaceAll("[\\s\n ]+", " ");
        return sql;
    }

    private String handleListParameter(String sql, Collection<?> col) {
        if (col != null && col.size() != 0) {
            for (Object obj : col) {
                String value = null;
                Class<String> objClass = obj.getClass();
                if (this.isPrimitiveOrPrimitiveWrapper(objClass)) {
                    value = obj.toString();
                } else if (objClass.isAssignableFrom(String.class)) {
                    value = "\"" + obj.toString() + "\"";
                }
                sql = sql.replaceFirst("\\?", value);
            }
        }
        return sql;
    }

    private String handleMapParameter(String sql, Map<?, ?> paramMap, List<ParameterMapping> parameterMappingList) {
        for (ParameterMapping parameterMapping : parameterMappingList) {
            String propertyName = parameterMapping.getProperty();
            Object propertyValue = paramMap.get(propertyName);
            if (propertyValue == null) continue;
            if (propertyValue.getClass().isAssignableFrom(String.class)) {
                propertyValue = "\"" + propertyValue + "\"";
            }
            sql = sql.replaceFirst("\\?", propertyValue.toString());
        }
        return sql;
    }

    private String handleCommonParameter(String sql, List<ParameterMapping> parameterMappingList, Class<?> parameterObjectClass, Object parameterObject) throws Exception {
        for (ParameterMapping parameterMapping : parameterMappingList) {
            String propertyValue = null;
            if (this.isPrimitiveOrPrimitiveWrapper(parameterObjectClass)) {
                propertyValue = parameterObject.toString();
            } else {
                String propertyName = parameterMapping.getProperty();
                Field field = parameterObjectClass.getDeclaredField(propertyName);
                field.setAccessible(true);
                propertyValue = String.valueOf(field.get(parameterObject));
                if (parameterMapping.getJavaType().isAssignableFrom(String.class)) {
                    propertyValue = "\"" + propertyValue + "\"";
                }
            }
            sql = sql.replaceFirst("\\?", propertyValue);
        }
        return sql;
    }

    private boolean isPrimitiveOrPrimitiveWrapper(Class<?> parameterObjectClass) {
        boolean isPrimitive = parameterObjectClass.isPrimitive() || parameterObjectClass.isAssignableFrom(Character.class) || parameterObjectClass.isAssignableFrom(Boolean.class);
        boolean isNaturalNum = parameterObjectClass.isAssignableFrom(Byte.class) || parameterObjectClass.isAssignableFrom(Short.class) || parameterObjectClass.isAssignableFrom(Integer.class) || parameterObjectClass.isAssignableFrom(Long.class);
        boolean isDecimal = parameterObjectClass.isAssignableFrom(Double.class) || parameterObjectClass.isAssignableFrom(Float.class);
        return isPrimitive || isNaturalNum || isDecimal;
    }

    private boolean isStrictMap(Class<?> parameterObjectClass) {
        return parameterObjectClass.isAssignableFrom(DefaultSqlSession.StrictMap.class);
    }

    private boolean isList(Class<?> clazz) {
        Class<?>[] interfaceClasses;
        for (Class<List> clazz2 : interfaceClasses = clazz.getInterfaces()) {
            if (!clazz2.isAssignableFrom(List.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isMap(Class<?> parameterObjectClass) {
        Class<?>[] interfaceClasses;
        for (Class<Map> clazz : interfaceClasses = parameterObjectClass.getInterfaces()) {
            if (!clazz.isAssignableFrom(Map.class)) continue;
            return true;
        }
        return false;
    }
}

