/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.cloud.app.conf;

import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.cloud.biz.service.user.TroCloudUserService;
import io.shulie.tro.cloud.biz.service.user.TroUserService;
import io.shulie.tro.cloud.common.context.LoginUser;
import io.shulie.tro.cloud.common.context.RestContext;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class GlobleAuthFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(GlobleAuthFilter.class);
    private static final String LICENSE_KEY = "licenseKey";
    private static final String FILTER_SQL = "filterSql";
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private TroCloudUserService troCloudUserService;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RestContext.clear();
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        RestContext.setHttpServletRequest((HttpServletRequest)httpServletRequest);
        RestContext.setHttpServletResponse((HttpServletResponse)httpServletResponse);
        try {
            LoginUser user;
            Long userId = (Long)httpServletRequest.getSession().getAttribute("login_user_session");
            if (userId != null && (user = (LoginUser)this.redisTemplate.opsForValue().get((Object)("tro:user:login" + userId))) != null) {
                RestContext.setUser((LoginUser)user);
                RestContext.getUser().setLoginChannel(Integer.valueOf(0));
                httpServletRequest.getSession().setMaxInactiveInterval(TroUserService.maxWait);
                this.redisTemplate.opsForValue().set((Object)("tro:user:login" + user.getId()), (Object)user, (long)TroUserService.maxWait, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.error("GlobleAuthFilter Console\uff1a" + e.getMessage(), (Throwable)e);
        }
        try {
            String license = httpServletRequest.getHeader(LICENSE_KEY);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{license})) {
                String filterSql = httpServletRequest.getHeader(FILTER_SQL);
                RestContext.setFilterSql((String)filterSql);
                User user = this.troCloudUserService.queryUserByKey(license);
                if (user != null) {
                    RestContext.setUser((LoginUser)this.convert(user));
                    RestContext.getUser().setLoginChannel(Integer.valueOf(1));
                }
            }
        }
        catch (Exception e) {
            logger.error("GlobleAuthFilter License\uff1a" + e.getMessage(), (Throwable)e);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private LoginUser convert(User user) {
        if (user == null) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        BeanUtils.copyProperties((Object)user, (Object)loginUser);
        return loginUser;
    }
}

