/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.cloud.app.conf;

import io.shulie.tro.cloud.common.bean.engine.EngineVersionConfigBean;
import io.shulie.tro.cloud.common.redis.RedisClientUtils;
import io.shulie.tro.cloud.common.utils.FileUtils;
import io.shulie.tro.utils.json.JsonHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EnginePackVersionConfig {
    private static final Logger log = LoggerFactory.getLogger(EnginePackVersionConfig.class);
    @Value(value="${engine.pack.version.path:/data/apps/tro-cloud/engine_pack_version.json}")
    private String enginePackVersionConfigJson;
    @Value(value="${pressure.engine.install.dir:/Users/hezhongqi/shulie/engine/pressure-engine.tar.gz}")
    private String installDir;
    @Autowired
    private RedisClientUtils redisClientUtils;

    @PostConstruct
    public void init() {
        try {
            List beans = JsonHelper.json2List((String)FileUtils.readTextFileContent((File)new File(this.enginePackVersionConfigJson)), EngineVersionConfigBean.class);
            Map<String, Object> configMap = beans.stream().collect(Collectors.toMap(EngineVersionConfigBean::getMd5, EngineVersionConfigBean::getVersion));
            this.redisClientUtils.hmset("ENGINE:PACK:VERSION:KEY", configMap);
            if (!new File(this.installDir).exists()) {
                log.error("\u672a\u627e\u5230\u5f15\u64ce\u5305");
                return;
            }
            String md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(this.installDir));
            Object version = this.redisClientUtils.hmget("ENGINE:PACK:VERSION:KEY", md5);
            if (version == null) {
                log.error("\u672a\u627e\u5230\u652f\u6301\u7248\u672c\u7684\u5f15\u64ce\u5305");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

