/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.cloud.app.aspect;

import io.shulie.tro.cloud.common.annotation.DataApartInterceptAnnotation;
import io.shulie.tro.cloud.common.context.RestContext;
import io.shulie.tro.cloud.common.utils.CustomUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataApartInterceptor
implements Interceptor {
    private static final String[] tables = new String[]{"t_scene_manage", "t_report"};

    public static void main(String[] args) {
        String sql1 = "select * from t_aaa where id = 1";
        String sql2 = "select * from t_report where id = 1";
        String sql3 = "select * from t_report";
        String sql4 = "select a as A, b as aB from t_report order by id";
        DataApartInterceptor interceptor = new DataApartInterceptor();
        System.out.println("After sql1 = " + interceptor.setSql(sql1, interceptor.matchTableIndex(sql1)));
        System.out.println("After sql2 = " + interceptor.setSql(sql2, interceptor.matchTableIndex(sql2)));
        System.out.println("After sql3 = " + interceptor.setSql(sql3, interceptor.matchTableIndex(sql3)));
        System.out.println("After sql4 = " + interceptor.setSql(sql4, interceptor.matchTableIndex(sql4)));
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (RestContext.getUser() == null || RestContext.getUser().getLoginChannel() == 0) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        String sqlCommandType = mappedStatement.getSqlCommandType().toString();
        if (!"select".equals(sqlCommandType.toLowerCase())) {
            return invocation.proceed();
        }
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = boundSql.getSql();
        String mSql = sql;
        int tableIndex = this.matchTableIndex(mSql);
        if (tableIndex < 0) {
            return invocation.proceed();
        }
        String mName = mappedStatement.getId().substring(mappedStatement.getId().lastIndexOf(".") + 1);
        if (mName.endsWith("_COUNT")) {
            mSql = this.setSql(mSql, tableIndex);
        } else {
            Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
            for (Method method : classType.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(DataApartInterceptAnnotation.class) || !mName.equals(method.getName())) continue;
                mSql = this.setSql(mSql, tableIndex);
            }
        }
        Field field = boundSql.getClass().getDeclaredField("sql");
        field.setAccessible(true);
        field.set(boundSql, mSql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private String setSql(String sql, int tableIndex) {
        return this.insertSql(tableIndex, sql, CustomUtil.getUserId());
    }

    private String insertSql(int tableIndex, String sql, Long userId) {
        StringBuffer sb = new StringBuffer();
        int pos = this.lowerIndexOf(sql, " where ");
        String filterSql = RestContext.getFilterSql();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filterSql})) {
            filterSql = "user_id in " + filterSql;
        }
        if (pos > 0) {
            sb.append(sql.substring(0, pos));
            sb.append(" where custom_id = " + userId);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filterSql})) {
                sb.append(" and " + filterSql);
            }
            sb.append(" and ");
            sb.append(sql.substring(pos + " where ".length()));
        } else {
            int index = this.lowerIndexOf(sql, tables[tableIndex]);
            sb.append(sql.substring(0, index));
            sb.append(tables[tableIndex]);
            sb.append(" where custom_id = " + userId);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filterSql})) {
                sb.append(" and " + filterSql);
            }
            sb.append(sql.substring(index + tables[tableIndex].length()));
        }
        return sb.toString();
    }

    private int matchTableIndex(String sql) {
        for (int i = 0; i < tables.length; ++i) {
            if (this.lowerIndexOf(sql, tables[i]) <= 0 || this.lowerIndexOf(sql, tables[i] + "_") != -1) continue;
            return i;
        }
        return -1;
    }

    private int lowerIndexOf(String sql, String str) {
        return sql.toLowerCase().indexOf(str.toLowerCase());
    }
}

